

generate_data <- function(n){
 # E[C] = a_c
 a_c = 0
 C <- rnorm(n, a_c, 1)
 
 # p(A = 1 | C) = 1/{1 + exp(b_0 + b_c*C)}
 b_0 = 0.5 
 b_c = 0.5 
 p_A1 <- 1/(1 + exp(b_0 + b_c*C))
 A <- rbinom(n, size=1, prob=p_A1)
 
 # p(M | C, A) = 1/{1 + exp(c_0 + c_c*C + c_a*A + c_ac*A*C)}
 c_0 = 0.5
 c_c = 1
 c_a = 0.5 
 c_ac = -1
 p_M1 <- 1/(1 + exp(c_0 + c_c*C + c_a*A + c_ac*A*C))
 M <- rbinom(n, size=1, prob=p_M1)
 
 # p(L | C, A, M) = 1/{1 + exp(d_0 + d_c*C + d_a*A + d_m*M + d_ac*A*C + d_am*A*M + d_acm*A*C*M)}
 d_0 = 0.5
 d_c = 1
 d_a = 0.5 
 d_m = 0.25
 d_ac = -1
 d_am = -0.5
 d_acm = -0.25
 p_L1 <- 1/(1 + exp(d_0 + d_c*C + d_a*A + d_m*M + d_ac*A*C + d_am*A*M + d_acm*A*C*M))
 L <- rbinom(n, size=1, prob=p_L1)
 
 
 # E[Y | C,A,M,L] = e_0 + e_c*C + e_a*A + e_m*M + e_l*L + e_ac*A*C + e_am*A*M + e_al*A*L + e_aml*A*M*L
 e_0 = 1 
 e_c = 1 
 e_a = 2 
 e_m = 1
 e_l = 0.5
 e_ac = -2  
 e_am = 1 
 e_al = 1 
 e_aml = -1.5
 eps <- rnorm(n, 0, 1)
 Y <- e_0 + e_c*C + e_a*A + e_m*M + e_l*L + e_ac*A*C + e_am*A*M + e_al*A*L + e_aml*A*M*L + eps
 
 # Data 
 dat = data.frame(1, C, A, M, L, A*C, A*M, A*L, A*C*M, A*M*L, Y)
 colnames(dat) = c("(Intercept)", "C", "A", "M", "L", "AC", "AM", "AL", "ACM", "AML", "Y")
 
 # Coefficinets
 beta_a = -c(b_0, b_c)
 names(beta_a) = c("(Intercept)", "C")
 beta_m = -c(c_0, c_c, c_a, c_ac)
 names(beta_m) = c("(Intercept)", "C", "A", "AC")
 beta_l = -c(d_0, d_c, d_a, d_m, d_ac, d_am, d_acm)
 names(beta_l) = c("(Intercept)", "C", "A", "M", "AC", "AM", "ACM")
 beta_y = c(e_0, e_c, e_a, e_m, e_l, e_ac, e_am, e_al, e_aml)
 names(beta_y) = c("(Intercept)", "C", "A", "M", "L", "AC", "AM", "AL", "AML")
 
 return(list(data=dat, 
             beta_a=beta_a, 
             beta_m=beta_m, 
             beta_l=beta_l,
             beta_y=beta_y))
}

